/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.audio.IAmbientSoundHandler;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;

public class BiomeSoundHandler
implements IAmbientSoundHandler {
    private final ClientPlayerEntity field_239510_a_;
    private final SoundHandler field_239511_b_;
    private final BiomeManager field_239512_c_;
    private final Random field_239513_d_;
    private Object2ObjectArrayMap<Biome, Sound> field_239514_e_ = new Object2ObjectArrayMap();
    private Optional<MoodSoundAmbience> field_239515_f_ = Optional.empty();
    private Optional<SoundAdditionsAmbience> field_239516_g_ = Optional.empty();
    private float field_239517_h_;
    private Biome field_239518_i_;

    public BiomeSoundHandler(ClientPlayerEntity clientPlayerEntity, SoundHandler soundHandler, BiomeManager biomeManager) {
        this.field_239513_d_ = clientPlayerEntity.field_70170_p.func_201674_k();
        this.field_239510_a_ = clientPlayerEntity;
        this.field_239511_b_ = soundHandler;
        this.field_239512_c_ = biomeManager;
    }

    public float func_239523_b_() {
        return this.field_239517_h_;
    }

    @Override
    public void func_204253_a() {
        this.field_239514_e_.values().removeIf(TickableSound::func_147667_k);
        Biome biome = this.field_239512_c_.func_235198_a_(this.field_239510_a_.func_226277_ct_(), this.field_239510_a_.func_226278_cu_(), this.field_239510_a_.func_226281_cx_());
        if (biome != this.field_239518_i_) {
            this.field_239518_i_ = biome;
            this.field_239515_f_ = biome.func_235092_v_();
            this.field_239516_g_ = biome.func_235093_w_();
            this.field_239514_e_.values().forEach(Sound::func_239526_p_);
            biome.func_235091_u_().ifPresent(soundEvent -> {
                Sound cfr_ignored_0 = (Sound)this.field_239514_e_.compute((Object)biome, (biome, sound) -> {
                    if (sound == null) {
                        sound = new Sound((SoundEvent)soundEvent);
                        this.field_239511_b_.func_147682_a((ISound)sound);
                    }
                    sound.func_239527_q_();
                    return sound;
                });
            });
        }
        this.field_239516_g_.ifPresent(soundAdditionsAmbience -> {
            if (this.field_239513_d_.nextDouble() < soundAdditionsAmbience.func_235024_b_()) {
                this.field_239511_b_.func_147682_a(SimpleSound.func_239530_b_(soundAdditionsAmbience.func_235021_a_()));
            }
        });
        this.field_239515_f_.ifPresent(moodSoundAmbience -> {
            World world = this.field_239510_a_.field_70170_p;
            int \u26032 = moodSoundAmbience.func_235037_c_() * 2 + 1;
            BlockPos \u26033 = new BlockPos(this.field_239510_a_.func_226277_ct_() + (double)this.field_239513_d_.nextInt(\u26032) - (double)moodSoundAmbience.func_235037_c_(), this.field_239510_a_.func_226280_cw_() + (double)this.field_239513_d_.nextInt(\u26032) - (double)moodSoundAmbience.func_235037_c_(), this.field_239510_a_.func_226281_cx_() + (double)this.field_239513_d_.nextInt(\u26032) - (double)moodSoundAmbience.func_235037_c_());
            int \u26034 = world.func_226658_a_(LightType.SKY, \u26033);
            this.field_239517_h_ = \u26034 > 0 ? (this.field_239517_h_ -= (float)\u26034 / (float)world.func_201572_C() * 0.001f) : (this.field_239517_h_ -= (float)(world.func_226658_a_(LightType.BLOCK, \u26033) - 1) / (float)moodSoundAmbience.func_235035_b_());
            if (this.field_239517_h_ >= 1.0f) {
                double d = (double)\u26033.func_177958_n() + 0.5;
                \u2603 = (double)\u26033.func_177956_o() + 0.5;
                \u2603 = (double)\u26033.func_177952_p() + 0.5;
                \u2603 = d - this.field_239510_a_.func_226277_ct_();
                \u2603 = \u2603 - this.field_239510_a_.func_226280_cw_();
                \u2603 = \u2603 - this.field_239510_a_.func_226281_cx_();
                \u2603 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603);
                \u2603 = \u2603 + moodSoundAmbience.func_235039_d_();
                SimpleSound \u26035 = SimpleSound.func_239531_b_(moodSoundAmbience.func_235032_a_(), this.field_239510_a_.func_226277_ct_() + \u2603 / \u2603 * \u2603, this.field_239510_a_.func_226280_cw_() + \u2603 / \u2603 * \u2603, this.field_239510_a_.func_226281_cx_() + \u2603 / \u2603 * \u2603);
                this.field_239511_b_.func_147682_a(\u26035);
                this.field_239517_h_ = 0.0f;
            } else {
                this.field_239517_h_ = Math.max(this.field_239517_h_, 0.0f);
            }
        });
    }

    public static class Sound
    extends TickableSound {
        private int field_239524_n_;
        private int field_239525_o_;

        public Sound(SoundEvent soundEvent) {
            super(soundEvent, SoundCategory.AMBIENT);
            this.field_147659_g = true;
            this.field_147665_h = 0;
            this.field_147662_b = 1.0f;
            this.field_217862_m = true;
        }

        @Override
        public void func_73660_a() {
            if (this.field_239525_o_ < 0) {
                this.func_239509_o_();
            }
            this.field_239525_o_ += this.field_239524_n_;
            this.field_147662_b = MathHelper.func_76131_a((float)this.field_239525_o_ / 40.0f, 0.0f, 1.0f);
        }

        public void func_239526_p_() {
            this.field_239525_o_ = Math.min(this.field_239525_o_, 40);
            this.field_239524_n_ = -1;
        }

        public void func_239527_q_() {
            this.field_239525_o_ = Math.max(0, this.field_239525_o_);
            this.field_239524_n_ = 1;
        }
    }
}

